﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using DataAccess;

/// <summary>
/// Report methods and properties
/// </summary>
public class CReports
{
    /// <summary>
    /// Default constructor
    /// </summary>
	public CReports()
	{
		//
		// TODO: Add constructor logic here
		//
	}

    /// <summary>
    /// US:7277 US:7281 get the aggregate reports data set given the criteria passed in
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lModuleGroupID"></param>
    /// <param name="lMID"></param>
    /// <returns></returns>
    public DataSet GetAggReportDS(BaseMaster BaseMstr,
                                  long lModuleGroupID,
                                  long lMID
                                  )
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nModuleGroupID", lModuleGroupID);
        plist.AddInputParameter("pi_nMID", lMID);

        
        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS.GetAggReportRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }


    /// <summary>
    /// load the population
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="dtFrom"></param>
    /// <param name="dtTo"></param>
    /// <param name="lClinicalSetting"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <param name="lCPAID"></param>
    /// <param name="lImpairmentID"></param>
    /// <param name="lInjuryID"></param>
    /// <param name="lGenderID"></param>
    /// <param name="lMilStatusID"></param>
    /// <returns></returns>
    public bool LoadPopulation(BaseMaster BaseMstr,
                                  DateTime dtFrom,
                                  DateTime dtTo,
                                  long lClinicalSetting,
                                  long lRegionID,
                                  long lSiteID,
                                  long lCPAID,
                                  long lImpairmentID,
                                  long lInjuryID,
                                  long lGenderID,
                                  long lMilStatusID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_dtFrom", dtFrom);
        plist.AddInputParameter("pi_dtTo", dtTo);

        plist.AddInputParameter("pi_nClinicalSetting", lClinicalSetting);
        plist.AddInputParameter("pi_nRegionID", lRegionID);
        plist.AddInputParameter("pi_nSiteID", lSiteID);

        plist.AddInputParameter("pi_nCPAID", lCPAID);
        plist.AddInputParameter("pi_nImpairmentID", lImpairmentID);
        plist.AddInputParameter("pi_nInjuryID", lInjuryID);
        plist.AddInputParameter("pi_nGender", lGenderID);
        plist.AddInputParameter("pi_nMilStatusID", lMilStatusID);

        //call sp to get ds
        BaseMstr.DBConn.ExecuteOracleSP( "PCK_REPORTS.LoadPopulation",
                                         plist,
                                         out lStatusCode,
                                         out strStatusComment);

        if (lStatusCode == 0)
        {
            return true;
        }
        else
        {
            return false;
        }
    }


    /// <summary>
    /// get static list of impairments to choose from
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetImpairmentDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS.GetImpairmentRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// get dataset of injuries
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetInjuryDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_REPORTS.GetInjuryRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }
}